# Created in 2020 by Ryan A. Colyer.
# This work is released with CC0 into the public domain.
# https://creativecommons.org/publicdomain/zero/1.0/

def GenerateHTML(country_files, state_files):
  def ImageFiles(file_list):
    s = ''
    for f in file_list:
      s += \
f'''        <a href="{f}"><img class="plot" src="{f}"></a>
'''
    return s

  page = \
'''<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1 plus MathML 2.0 plus SVG 1.1//EN" "http://www.w3.org/2002/04/xhtml-math-svg/xhtml-math-svg.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xmlns:mathml="http://www.w3.org/1998/Math/MathML" xmlns:svg="http://www.w3.org/2000/svg" xml:lang="en">

  <head>
  <title>Coronavirus Covid-19 Plots</title>
  <style type="text/css">
    .plot {
      width:280pt;
    }
  </style>
  </head>

  <body>
    <center>
      <div>
        <a href="plots/World.png"><img class="plot" src="plots/World.png"></a>
        <a href="plots/World_outside_China.png"><img class="plot" src="plots/World_outside_China.png"></a>
      </div>
    </center>
    <h2 style="text-align:center;">Countries</h1>
    <center>
      <div>
'''
  page += ImageFiles(country_files)
  page += \
'''      </div>
    </center>
    <hr/>
    <h2 style="text-align:center;">U.S. States / Regions</h1>
    <center>
      <div>
'''
  page += ImageFiles(state_files)
  page += \
'''      </div>
    </center>
    <hr/>
    <h2 style="text-align:center;">Source Code and Notes</h1>
    <ul>
      <li>
        The Python source code for generating these plots and this page is
        freely available here:
        <a href="Covid19Plots.zip">Covid19Plots.zip</a>
      </li>
      <li>
        The Covid-19 data is sourced from Johns Hopkins CSSE at 
        <a href="https://github.com/CSSEGISandData/COVID-19">https://github.com/CSSEGISandData/COVID-19</a>
      </li>
      <li>
        CAUTION:  This data is largely a byproduct of its source data with
        some basic subtraction, fitting, and plotting.  The source data used
        is limited by the data available from official and other
        authoritative sources.  There are many conspicuous flaws.  Some
        regions may have misreported numbers for political purposes, which
        may appear as values not following the properties of naturally
        acquired data.  Nearly every region suffers from a substantial
        testing deficit of both confirmed cases and, usually to a lesser
        extent, confirmed deaths.  Active counts reported are a subtraction
        of confirmed from recovered and deaths, which suffers from poor
        follow-up on cases that likely recovered in many regions.  Some
        regions have also stopped (or never were) reporting recovered cases,
        in which case the value is reported as zero in the source data.
        Reporting of values in many regions is impacted by weekly patterns
        and other variations which disrupt the deaths-per-day values.  Making
        valid interpretations of this data requires careful consideration of
        the various flaws that contribute to the source values used.
      </li>
      <li>
        The dotted line marked "Projection" was an April 2020 estimate of
        resulting population-wide death rates based on case rates and fatality
        rates in select locations with exceptionally high early spread.  Being
        from April 2020, this estimate did not include subsequent variants nor
        the effects of vaccination.
      </li>
    </ul><br/>
  </body>
</html>
'''

  return page

